//================================================================================================
// This is the superclass of all driveable cars, made by WCCC, help from Anna, AKA Wild or WildCat
// With modeling help from DxP Alex, milkshape, and unreal fx
//================================================================================================
class MSDrivables extends Vehicles;

var DeusExPlayer MSCarDriver; //who is driving this
var DeusExPlayer MSCarPassenger; //who is gunning this
var float MSCarSpeed; //how fast the car is currently moving
var MenuUIDrivingWindow _DrivingScreen; //our current driving screen
var() int CarSpeed;//this x100 is the car's top speed
var() int BrakeStrength; // how strong are the brakes?
var() int MSAccelerationSpeed; //how fast the car speeds up, not sure if acceleration speed would have been taken or not :P
var() int TopGas; //the maximum gas the car can hold
var bool bStillDriving; //are you still pushing on the pedal?
var float LastGasTimer; //time since last push on the pedal
var() bool bUseGas; // do you want this car to use gas?
var float GasLeft; //the amount of gas left in the car, it starts out at max
var vector GarageLocation; //their first position should be here
var rotator InitialCarRotation; //their first rotation
var vector Push; //used to measure speed
var rotator CarRotation; //used for measuring rotation
var vector CurrentDrivableSpeed; //more speed crap
var DrivableWeapon LeftGun, RightGun; //used for gun controling
var vector LeftGunPos, RightGunPos, LRPGPos, RRPGPos; //Used for gun attachment locations
var rotator LeftGunRot, RightGunRot; //used for custom gun rotations relative to vehicles
var float EBrakeTimer; //used for ebrake feature :P
//var vector VehicleViewOffset; //used for calculating behind view (OBSOLETE)
var class<MenuUIDrivingWindow> DrivingScreenType, MPDrivingScreenType; //used for custom window types
var vector FiringOffsetR, FiringOffsetL; //used for correcting problems with projectiles colliding into the vehicles
var vector DriverPos, PassengerPos, DriverDump, PassengerDump;
var() class<DrivableWeapon> DefaultGun, KnownGuns[4]; //used for setting default gun types
var bool bAttachedGun;
var ParticleGenerator DamageSpots[10]; //an array of damaged spots on the car, these will continue to burn until the sequence is looped
var int DamageSpotCount; //which effect number are me going to play?
var() float VehicleRespawnTime; //how long until this vehicle respawns?

//Multiplayer fixes :P
var() class<Projectile> MPProjectileClass;
var() float ShotTime, ShotTimer;
var() sound MPFiringSound;

replication
{
     reliable if (Role == ROLE_Authority)
	MPFiringSound, ShotTime, MPProjectileClass, PlaySimSound, DamageSpotCount, LastGasTimer, ResetVehicle, bUseGas,GasLeft, DefaultGun, RightGunRot, LeftGunRot, LeftGunPos, RightGunPos, LRPGPos, RRPGPos, EBrakeTimer, LeftGun, RightGun, Push, InitialCarRotation, GarageLocation;
     reliable if (Role < ROLE_Authority)
        ShotTimer, FireDemGuns, CheckForRoadKill, MSCarDriver, MSCarPassenger, HandleLivingDriver, HandleDyingDriver, UpdatePassengerPos, HandleWaterDriving, GetDrivingStats, AimDown, AimUp, MSDriveForward, MSDriveBackward, MSTurnRight, MSTurnLeft, MSBrake, EjectPassenger, StopMSDriving, TopGas, CarSpeed, BrakeStrength, MSAccelerationSpeed;
}

/*simulated function actor MSSpawn(class<actor> SpawnClass, optional actor SpawnOwner, optional name SpawnTag, optional vector SpawnLocation, optional rotator SpawnRotation)
{
 Spawn(SpawnClass, SpawnOwner, SpawnTag, SpawnLocation, SpawnRotation);
}*/

simulated function PreBeginPlay()
{
 Super.PreBeginPlay();

 GasLeft = TopGas * 100000; //start off with a full tank
}

event HitWall( vector HitNormal, actor HitWall )
{
 if (HitWall.IsA('DeusExMover'))
  DeusExMover(HitWall).TakeDamage(MSCarSpeed * 360000 /16 /5280, MSCarDriver, HitWall.Location, Normal(Velocity) * 2000, 'Exploded');
 
 Super.HitWall(HitNormal, HitWall);
}

simulated function PostNetBeginPlay()
{
 local int GunNum;

 if ((Level.NetMode != NM_StandAlone) && (DefaultGun == None))
 {
  GunNum = Rand(4);
  DefaultGun = KnownGuns[GunNum];
 }
 if (Level.NetMode != NM_StandAlone)
 {
  LeftGun = Spawn(DefaultGun, Self,, Location);
  RightGun = Spawn(DefaultGun, Self,, Location);
  LeftGun.AttachedTo = Self;
  RightGun.AttachedTo = Self;
 }
 Super.PostNetBeginPlay();
}

simulated function PostBeginPlay()
{
 GarageLocation = Location;
 InitialCarRotation = Rotation;

 if ((DefaultGun != None) && (Level.NetMode == NM_Standalone))
 {
  LeftGun = Spawn(DefaultGun, Self,, Location);
  RightGun = Spawn(DefaultGun, Self,, Location);
  LeftGun.AttachedTo = Self;
  RightGun.AttachedTo = Self;
 }
 if (Level.NetMode != NM_StandAlone)
 {
 bUseGas = False;
 DrivingScreenType = MPDrivingScreenType;
 } 

 Super.PostBeginPlay();
}

simulated function ResetVehicle()
{
 SetLocation(GarageLocation);
 SetRotation(InitialCarRotation);
}

simulated function EjectPassenger()
{
 if (MSCarPassenger != None)
 {
    MSCarPassenger.SetLocation(Location + (PassengerDump >> Rotation)); 
    MSCarPassenger = None;
    if (IsInState('MSDriving2'));
    GoToState('MSDriving1');
 }
}

simulated function StopMSDriving()
{
    MSCarDriver.SetLocation(Location + (DriverDump >> Rotation)); 
    MSCarDriver.StartWalk();
//    MSCarDriver.ViewTarget = None;
//    MSCarDriver.bBehindView = False;
    MSCarDriver = None;
    SetOwner(None);
    /*if (MSCarPassenger != None)
    {
     MSCarPassenger.SetLocation(Location + (PassengerDump >> Rotation)); 
     MSCarPassenger = None;
    }*/
//    bBlockActors = True;
//    bBlockPlayers = True;
    if (Level.NetMode == NM_Standalone)
     _DrivingScreen = None;
   if (!IsInState('Exploding'))
   {
    SetPhysics(PHYS_Falling); //added because the car floats in the air otherwise...
    GoToState('Active');
   }
    return;  
}

function Frob(Actor Frobber, Inventory frobWith)
{
  local DeusExPlayer player;

 if (!Region.Zone.bWaterZone)
 {

  player = DeusExPlayer(Frobber);

/*  if ((player != None) && (MSCarDriver == None))
  {
    player.SetLocation(Self.Location - vect(0,0,1) * CollisionHeight / 2);
    MSCarDriver = player;
    bBlockActors = False;
   ForEach AllActors(class'DMSActor',SPAWNGODDAMMIT)
   { 
    if (SPAWNGODDAMMIT != None)
    {
     SPAWNGODDAMMIT.SpawnMSDMS(MSCarDriver, Self);
    }
   }            not handled by car anymore due to mp bugs
    return;
  }*/
 if ((player != None) && (MSCarDriver != None) && (MSCarPassenger == None) && (MSCarDriver != player))
 {
      MSCarPassenger = player;
      MSCarPassenger.SetLocation(Location + (PassengerDump >> Rotation));
      MSCarPassenger.LoopAnim('SitStill', 0.1);
      GoToState('MSDriving2');
      return;
 }
 }
}

simulated function UpdatePassengerPos()
{
      MSCarPassenger.SetLocation(Location + (PassengerPos >> Rotation));
      MSCarPassenger.ClientSetLocation(Location + (PassengerPos >> Rotation), MSCarPassenger.ViewRotation);
}

simulated function HandleLivingDriver()
{
    if ((MSCarDriver != None) && (!MSCarDriver.IsInState('Dying')))  //this makes the player follow the car
    {
       MSCarDriver.ClientSetLocation(Location + (DriverPos >> Rotation), Rotation + (rot(1,0,0) * LeftGunRot.Pitch));
       MSCarDriver.SetLocation(Location + (DriverPos >> Rotation));
     if (MSCarDriver.Physics != PHYS_None)
       MSCarDriver.SetPhysics(PHYS_None);
    }
}

simulated function HandleWaterDriving()
{
    if ((MSCarDriver != None) && (Region.Zone.bWaterZone))
    {
    MSCarDriver.SetLocation(Location + (DriverDump >> Rotation)); 
//    MSCarDriver.ViewTarget = None;
//    MSCarDriver.bBehindView = False;
    MSCarDriver.StartWalk();
    MSCarDriver = None;
   GoToState('Active');
    if (MSCarPassenger != None)
    {
     MSCarPassenger.SetLocation(Location + (PassengerDump >> Rotation)); 
     MSCarPassenger = None;
    }
    bBlockActors = True;
    bBlockPlayers = True;
   if (Level.NetMode == NM_StandAlone)
    _DrivingScreen.root.PopWindow();
    if (Level.NetMode == NM_Standalone)
     _DrivingScreen = None;
    SetPhysics(PHYS_Falling); //added because the car floats in the air otherwise...
     ResetVehicle();
    }
}

simulated function HandlePassenger()
{
    if (MSCarPassenger != None)
    {
     if (MSCarPassenger.IsInState('Dying'))
      {
      MSCarPassenger = None;
      GoToState('MSDriving1');
      }
     else
     {
      UpdatePassengerPos();
     }
    }
}

simulated function HandleDyingDriver()
{
 //Deemed unnecessary due to the fact that the car explodes before the player dies and kicks them out anyways.
}



simulated function string GetDrivingStats() //to be overridden in custom classes such as helicopters and whatnot 
{
 local string StatsMessage;
 
 StatsMessage = "Current Speed:"$MSCarSpeed * 360000 /16 /5280$" MPH, Gas Left: "$GasLeft / 50000$",|n Stats _/10: 1.Speed:"$CarSpeed$",2.Accel:"$MSAccelerationSpeed$",3.Gas:"$TopGas$",|n4.Brakes:"$BrakeStrength$", Weapon: "$LeftGun.GunName$", |nAmmoLeft: "$(LeftGun.AmmoLeft + RightGun.AmmoLeft) / LeftGun.NumberOfShots$"";
 
 return StatsMessage;
}

simulated function MSDriveForward()
{
        local vector vel;
        local float size;
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local vector NormalHeading, NormalDesiredHeading;
        local float HeadingDiffDot;

	position    = Location;
	position.Z += MSCarDriver.BaseEyeHeight;
	line        = Vector(MSCarDriver.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position + line, position, true);
          
         if (Level.Netmode != NM_Standalone)
         {
            NormalHeading = Normal(Vector(Rotation));
            NormalDesiredHeading = Normal(hitLocation - Location);
            HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
         }

         if (GasLeft > 0)
         {
         Push += vect(1,1,0) * CarSpeed * 100;
          if (Physics != PHYS_Projectile)
           SetPhysics(PHYS_Projectile);

          if ((Velocity.X + Velocity.Y > Push.X + Push.Y * -1) && (Velocity.X + Velocity.Y <= 0)) //if we aren't breaking our top speed
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed += vect(-1,0,0) * ((MSAccelerationSpeed - (2.5 / CarSpeed))* 6.5); // add its old speed plus some more
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // add the old speed plus a little extra
          }
          if ((Velocity.X + Velocity.Y < Push.X + Push.Y) && (Velocity.X + Velocity.Y >= 0)) //if we aren't breaking our top speed
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed += vect(1,0,0) * ((MSAccelerationSpeed - (2.5 / CarSpeed))* 6.5); // add its old speed plus some more
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // add the old speed plus a little extra
          }
          if (Velocity.X + Velocity.Y > Push.X + Push.Y) //if we ARE breaking out top speed, slow us down
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed -= CurrentDrivableSpeed; //set that speed to zero
           CurrentDrivableSpeed += vect(1,0,0) * CarSpeed * 100; //set speed to top speed
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // and finally set it to top speed
          }
          if (Velocity.X + Velocity.Y < Push.X + Push.Y * -1) //if we ARE breaking out top speed, slow us down
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed -= CurrentDrivableSpeed; //set that speed to zero
           CurrentDrivableSpeed -= vect(1,0,0) * CarSpeed * 100; //set speed to top speed
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // and finally set it to top speed
          }
         size = VSize(Velocity); //arg velocity hack copied from deusexprojectile.uc
         vel = Normal(Vector(Rotation));
         if (Level.NetMode != NM_Standalone)
         {
            size = FMax(HeadingDiffDot,0.4) * (Velocity.X + Velocity.Y);
         }
         Velocity = vel * size;
         LastGasTimer = 0.500000; //notify the car that we're still on the gas
         }
}

simulated function MSDriveBackward()
{
 	local vector vel;
 	local float size;
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local vector NormalHeading, NormalDesiredHeading;
        local float HeadingDiffDot;

	position    = Location;
	position.Z += MSCarDriver.BaseEyeHeight;
	line        = Vector(MSCarDriver.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position + line, position, true);
          
         if (Level.Netmode != NM_Standalone)
         {
            NormalHeading = Normal(Vector(MSCarDriver.Rotation));
            NormalDesiredHeading = Normal(hitLocation - MSCarDriver.Location);
            HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
         }

         if (GasLeft > 0)
         {
         Push += vect(1,1,0) * CarSpeed * 100 / 2;
          if (Physics != PHYS_Projectile)
           SetPhysics(PHYS_Projectile);

          if ((Velocity.X + Velocity.Y > Push.X + Push.Y * -1) && (Velocity.X + Velocity.Y <= 0)) //if we aren't breaking our top speed
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed += vect(-1,0,0) * ((MSAccelerationSpeed - (2.5 / CarSpeed))* 6.5); // add its old speed plus some more
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // add the old speed plus a little extra
          }
          if ((Velocity.X + Velocity.Y < Push.X + Push.Y) && (Velocity.X + Velocity.Y >= 0)) //if we aren't breaking our top speed
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed += vect(1,0,0) * ((MSAccelerationSpeed - (2.5 / CarSpeed))* 6.5); // add its old speed plus some more
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // add the old speed plus a little extra
          }
          if (Velocity.X + Velocity.Y > Push.X + Push.Y) //if we ARE breaking out top speed, slow us down
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed -= CurrentDrivableSpeed; //set that speed to zero
           CurrentDrivableSpeed += vect(1,0,0) * CarSpeed * 100; //set speed to top speed
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // and finally set it to top speed
          }
          if (Velocity.X + Velocity.Y < Push.X + Push.Y * -1) //if we ARE breaking out top speed, slow us down
          {
           CurrentDrivableSpeed = Velocity; //get current speed
           CurrentDrivableSpeed -= CurrentDrivableSpeed; //set that speed to zero
           CurrentDrivableSpeed -= vect(1,0,0) * CarSpeed * 100; //set speed to top speed
	   Velocity -= Velocity; // set speed to zero for a split second
	   Velocity -= CurrentDrivableSpeed; // and finally set it to top speed
          }
         size = VSize(Velocity); //arg velocity hack copied from deusexprojectile.uc
         vel = Normal(Vector(Rotation));
         if (Level.NetMode != NM_Standalone)
         {
            size = FMax(HeadingDiffDot,0.4) * (Velocity.X + Velocity.Y);
         }
         Velocity = vel * size * -1;
         LastGasTimer = 0.500000; //notify the car that we're still on the gas
         }
}

simulated function MSTurnLeft()
{
        local vector vel;
        local float size;
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local vector NormalHeading, NormalDesiredHeading;
        local float HeadingDiffDot;

         if (GasLeft > 0)
         {
          CarRotation = Rotation; //get current rotation
          CarRotation.Yaw -= BrakeStrength * 200; //minus the turn rate (minus goes to the left)
          SetRotation(CarRotation); //and turn the car to this rotation
         size = VSize(Velocity); //arg velocity hack copied from deusexprojectile.uc
         vel = Normal(Vector(Rotation));
	position    = Location;
	position.Z += MSCarDriver.BaseEyeHeight;
	line        = Vector(MSCarDriver.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position + line, position, true);

         if (EBrakeTimer <= 0)
          Velocity = vel * size * -1;

         if (Level.Netmode != NM_Standalone)
         {
            NormalHeading = Normal(Vector(Rotation));
            NormalDesiredHeading = Normal(hitLocation - Location);
            HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
         }
//         if (Level.NetMode != NM_Standalone) //this fucks things up in mp
//         {
//            size = FMax(HeadingDiffDot,0.4) * (Velocity.X + Velocity.Y);
//         }
         if (EBrakeTimer <= 0)
          Velocity = vel * size;
         LastGasTimer = 0.500000; //notify the car that we're still on the gas
         }
}

simulated function MSTurnRight()
{
 	local vector vel;
 	local float size;
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local vector NormalHeading, NormalDesiredHeading;
        local float HeadingDiffDot;
        local float VelX, VelY;

         if (GasLeft > 0)
         {
          CarRotation = Rotation; //get current rotation
          CarRotation.Yaw += BrakeStrength * 200; //add the turn rate (add goes to the right)
          SetRotation(CarRotation); //and turn the car to this rotation
         size = VSize(Velocity); //arg velocity hack copied from deusexprojectile.uc
         vel = Normal(Vector(Rotation));

	position    = Location;
	position.Z += MSCarDriver.BaseEyeHeight;
	line        = Vector(MSCarDriver.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position + line, position, true);

         if (EBrakeTimer <= 0)
          Velocity = vel * size;

         if (Level.Netmode != NM_Standalone)
         {
            NormalHeading = Normal(Vector(Rotation));
            NormalDesiredHeading = Normal(hitLocation - Location);
            HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
         }
//         if (Level.NetMode != NM_Standalone) //this fucks things up in mp
//         {
//            size = FMax(HeadingDiffDot,0.4) * (Velocity.X + Velocity.Y);
//         }
         LastGasTimer = 0.500000; //notify the car that we're still on the gas
         }
}

simulated function AimDown()
{
    LeftGunRot -= rot(640,0,0);
    RightGunRot -= rot(640,0,0);
}

simulated function AimUp()
{
    LeftGunRot += rot(640,0,0);
    RightGunRot += rot(640,0,0);
}

simulated function MSBrake()
{
         Velocity -= Velocity / 20 * 1.5 * BrakeStrength; //minus __% of the speed, maximum of 75%
}

auto state Active
{
	function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		local float avg;

		if (bStatic || bInvincible)
			return;

		if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
			return;

		if ((DamageType == 'EMP') || (DamageType == 'NanoVirus') || (DamageType == 'Shocked'))
			return;

		if (DamageType == 'HalonGas')
			ExtinguishFire();

		if ((DamageType == 'Burned') || (DamageType == 'Flamed'))
		{
			if (bExplosive)		// blow up if we are hit by fire
				HitPoints = 0;
			else if (bFlammable && !Region.Zone.bWaterZone)
			{
				GotoState('Burning');
				return;
			}
		}

		if (Damage >= minDamageThreshold)
			HitPoints -= Damage;
		else
		{
			// sabot damage at 50%
			// explosion damage at 25%
			if (damageType == 'Sabot')
				HitPoints -= Damage * 0.5;
			else if (damageType == 'Exploded')
				HitPoints -= Damage * 0.25;
		}

		if (HitPoints > 0)		// darken it to show damage (from 1.0 to 0.1 - don't go completely black)
		{
			ResetScaleGlow();
		}
		else	// destroy it!
		{
			DropThings();

			// clear the event to keep Destroyed() from triggering the event
			Event = '';
			avg = (CollisionRadius + CollisionHeight) / 2;
			Instigator = EventInstigator;
			if (Instigator != None)
				MakeNoise(1.0);

			if (fragType == class'WoodFragment')
			{
				if (avg > 20)
					PlaySound(sound'WoodBreakLarge', SLOT_Misc,,, 512);
				else
					PlaySound(sound'WoodBreakSmall', SLOT_Misc,,, 512);
				AISendEvent('LoudNoise', EAITYPE_Audio, , 512);
			}

			// if we have been blown up, then destroy our contents
			// CNN - don't destroy contents now
//			if (DamageType == 'Exploded')
//			{
//				Contents = None;
//				Content2 = None;
//				Content3 = None;
//			}

			if (bExplosive)
			{
				Frag(fragType, Momentum * explosionRadius / 4, avg/35.0, avg/10 + 1);
				Explode(HitLocation);
			}
			else
				Frag(fragType, Momentum / 10, avg/20.0, avg/5 + 1);
		}
          	if (Damage >= 1)
		{
                        if (DamageSpots[DamageSpotCount] != None)
                         DamageSpots[DamageSpotCount].DelayedDestroy();

		    	DamageSpots[DamageSpotCount] = Spawn(class'ParticleGenerator', Self,, HitLocation);
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Sabot'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.123;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = Damage / 50;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType != 'Sabot') && (DamageType != 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.09;
				DamageSpots[DamageSpotCount].checkTime = 0.035;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
                	if ((Damage >= 25) || (HitPoints < Default.HitPoints / 2))
			{
				Frag(fragType, Momentum / 10, avg/30.0, avg/5 + 1);
			}
		}
	}
}

state MSDriving1
{
function Tick(float DeltaTime)
{
  local Actor Other;
  local int X, Y;
  local vector PassengerDump;
//  local rotator WORKDAMMIT;

//  if (MSCarDriver != None)
//  {
//    SetLocation(MSCarDriver.Location + vect(0,0,1) * CollisionHeight / 2);
//a little calculation to measure how fast the car is going, used for damage calculation.
//    MSCarSpeed = (MSCarDriver.Location.X - MSCarDriver.OldLocation.X) + (MSCarDriver.Location.Y - MSCarDriver.OldLocation.Y);
 if ((LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos != LRPGPos))
 {
   LeftGunPos = LRPGPos;
   RightGunPos = RRPGPos;
 }
 if ((!LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos == LRPGPos))
 {
   LeftGunPos = Default.LeftGunPos;
   RightGunPos = Default.RightGunPos;
 }
    MSCarSpeed = VSize(Velocity) / 21.5;
    if (MSCarSpeed < 1) MSCarSpeed = 0;

    if (bUseGas) //if we are using gas
    {
     if (Velocity != vect(0,0,0)) //and we're moving
     {                            //subtract our velocity from our gas
      if (Velocity.X > 0)
       GasLeft -= DeltaTime * Velocity.X; 
      if (Velocity.Y > 0)
       GasLeft -= DeltaTime * Velocity.Y;
      if (Velocity.X < 0)
       GasLeft -= DeltaTime * Velocity.X * -1;
      if (Velocity.Y < 0)
       GasLeft -= DeltaTime * Velocity.Y * -1;
     }
    }

     //HandleWaterDriving();

    if ((Region.Zone.IsA('RefuelingZone')) && (GasLeft < TopGas * 100000))
     GasLeft += DeltaTime * TopGas * 10000;

    if (GasLeft > TopGas * 100000)
     GasLeft = TopGas * 100000;

    if (LastGasTimer > 0) //if the gas timer isnt too low, decrease it
    {
          LastGasTimer -= DeltaTime;
          bStillDriving = True;
    }
  
    if (EBrakeTimer > 0)
     EBrakeTimer -= DeltaTime;

    if (LastGasTimer <= 0) //if its been too long, assume we've stopped driving
       if (bStillDriving)
          bStillDriving = False;

                         //UPDATE: added shit for drifting
    if ((!bStillDriving) && (EBrakeTimer <= 0)) //projectile physics dont slow themselves, so lets do that automatically
       if (Velocity != vect(0,0,0))
          Velocity -= Velocity / 20 * 0.4 * BrakeStrength; //minus __% of the speed, maximum of 20%

	if (ShotTimer > 0)
         ShotTimer -= DeltaTime;

     HandleDyingDriver();
    
     //HandlePassenger();

     HandleLivingDriver();

     CheckForRoadKill(Other);

    if ((MSCarDriver != None) && (_DrivingScreen != None))
     _DrivingSCreen.SetMessageText(GetDrivingStats());
//  }  
}

	function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		local float avg;

		if (bStatic || bInvincible)
			return;

		if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
			return;

		if ((DamageType == 'EMP') || (DamageType == 'NanoVirus') || (DamageType == 'Shocked'))
			return;

		if (DamageType == 'HalonGas')
			ExtinguishFire();

		if ((DamageType == 'Burned') || (DamageType == 'Flamed'))
		{
			if (bExplosive)		// blow up if we are hit by fire
				HitPoints = 0;
			else if (bFlammable && !Region.Zone.bWaterZone)
			{
				GotoState('Burning');
				return;
			}
		}

		if (Damage >= minDamageThreshold)
			HitPoints -= Damage;
		else
		{
			// sabot damage at 50%
			// explosion damage at 25%
			if (damageType == 'Sabot')
				HitPoints -= Damage * 0.5;
			else if (damageType == 'Exploded')
				HitPoints -= Damage * 0.25;
		}

		if (HitPoints > 0)		// darken it to show damage (from 1.0 to 0.1 - don't go completely black)
		{
			ResetScaleGlow();
		}
		else	// destroy it!
		{
			DropThings();

			// clear the event to keep Destroyed() from triggering the event
			Event = '';
			avg = (CollisionRadius + CollisionHeight) / 2;
			Instigator = EventInstigator;
			if (Instigator != None)
				MakeNoise(1.0);

			if (fragType == class'WoodFragment')
			{
				if (avg > 20)
					PlaySound(sound'WoodBreakLarge', SLOT_Misc,,, 512);
				else
					PlaySound(sound'WoodBreakSmall', SLOT_Misc,,, 512);
				AISendEvent('LoudNoise', EAITYPE_Audio, , 512);
			}

			// if we have been blown up, then destroy our contents
			// CNN - don't destroy contents now
//			if (DamageType == 'Exploded')
//			{
//				Contents = None;
//				Content2 = None;
//				Content3 = None;
//			}

			if (bExplosive)
			{
				Frag(fragType, Momentum * explosionRadius / 4, avg/35.0, avg/10 + 1);
				Explode(HitLocation);
			}
			else
				Frag(fragType, Momentum / 10, avg/20.0, avg/5 + 1);
		}
          	if (Damage >= 1)
		{
                        if (DamageSpots[DamageSpotCount] != None)
                         DamageSpots[DamageSpotCount].DelayedDestroy();

		    	DamageSpots[DamageSpotCount] = Spawn(class'ParticleGenerator', Self,, HitLocation);
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Sabot'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.123;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = Damage / 50;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType != 'Sabot') && (DamageType != 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.09;
				DamageSpots[DamageSpotCount].checkTime = 0.035;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
                	if ((Damage >= 25) || (HitPoints < Default.HitPoints / 2))
			{
				Frag(fragType, Momentum / 10, avg/30.0, avg/5 + 1);
			}
		}
	}
}

state MSDriving2
{
function Tick(float DeltaTime)
{
  local Actor Other;
  local int X, Y;
  local vector PassengerDump;
//  local rotator WORKDAMMIT;

//  if (MSCarDriver != None)
//  {
//    SetLocation(MSCarDriver.Location + vect(0,0,1) * CollisionHeight / 2);
//a little calculation to measure how fast the car is going, used for damage calculation.
//    MSCarSpeed = (MSCarDriver.Location.X - MSCarDriver.OldLocation.X) + (MSCarDriver.Location.Y - MSCarDriver.OldLocation.Y);
 if ((LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos != LRPGPos))
 {
   LeftGunPos = LRPGPos;
   RightGunPos = RRPGPos;
 }
 if ((!LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos == LRPGPos))
 {
   LeftGunPos = Default.LeftGunPos;
   RightGunPos = Default.RightGunPos;
 }
    MSCarSpeed = VSize(Velocity) / 21.5;
    if (MSCarSpeed < 1) MSCarSpeed = 0;

    if (bUseGas) //if we are using gas
    {
     if (Velocity != vect(0,0,0)) //and we're moving
     {                            //subtract our velocity from our gas
      if (Velocity.X > 0)
       GasLeft -= DeltaTime * Velocity.X; 
      if (Velocity.Y > 0)
       GasLeft -= DeltaTime * Velocity.Y;
      if (Velocity.X < 0)
       GasLeft -= DeltaTime * Velocity.X * -1;
      if (Velocity.Y < 0)
       GasLeft -= DeltaTime * Velocity.Y * -1;
     }
    }

     //HandleWaterDriving();

    if ((Region.Zone.IsA('RefuelingZone')) && (GasLeft < TopGas * 100000))
     GasLeft += DeltaTime * TopGas * 10000;

    if (GasLeft > TopGas * 100000)
     GasLeft = TopGas * 100000;

    if (LastGasTimer > 0) //if the gas timer isnt too low, decrease it
    {
          LastGasTimer -= DeltaTime;
          bStillDriving = True;
    }
  
    if (EBrakeTimer > 0)
     EBrakeTimer -= DeltaTime;

    if (LastGasTimer <= 0) //if its been too long, assume we've stopped driving
       if (bStillDriving)
          bStillDriving = False;

                         //UPDATE: added shit for drifting
    if ((!bStillDriving) && (EBrakeTimer <= 0)) //projectile physics dont slow themselves, so lets do that automatically
       if (Velocity != vect(0,0,0))
          Velocity -= Velocity / 20 * 0.4 * BrakeStrength; //minus __% of the speed, maximum of 20%

	if (ShotTimer > 0)
         ShotTimer -= DeltaTime;
	

     HandleDyingDriver();
    
     HandlePassenger();

     HandleLivingDriver();

     CheckForRoadKill(Other);

    if ((MSCarDriver != None) && (_DrivingScreen != None))
     _DrivingSCreen.SetMessageText(GetDrivingStats());
//  }  
}

	function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		local float avg;

		if (bStatic || bInvincible)
			return;

		if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
			return;

		if ((DamageType == 'EMP') || (DamageType == 'NanoVirus') || (DamageType == 'Shocked'))
			return;

		if (DamageType == 'HalonGas')
			ExtinguishFire();

		if ((DamageType == 'Burned') || (DamageType == 'Flamed'))
		{
			if (bExplosive)		// blow up if we are hit by fire
				HitPoints = 0;
			else if (bFlammable && !Region.Zone.bWaterZone)
			{
				GotoState('Burning');
				return;
			}
		}

		if (Damage >= minDamageThreshold)
			HitPoints -= Damage;
		else
		{
			// sabot damage at 50%
			// explosion damage at 25%
			if (damageType == 'Sabot')
				HitPoints -= Damage * 0.5;
			else if (damageType == 'Exploded')
				HitPoints -= Damage * 0.25;
		}

		if (HitPoints > 0)		// darken it to show damage (from 1.0 to 0.1 - don't go completely black)
		{
			ResetScaleGlow();
		}
		else	// destroy it!
		{
			DropThings();

			// clear the event to keep Destroyed() from triggering the event
			Event = '';
			avg = (CollisionRadius + CollisionHeight) / 2;
			Instigator = EventInstigator;
			if (Instigator != None)
				MakeNoise(1.0);

			if (fragType == class'WoodFragment')
			{
				if (avg > 20)
					PlaySound(sound'WoodBreakLarge', SLOT_Misc,,, 512);
				else
					PlaySound(sound'WoodBreakSmall', SLOT_Misc,,, 512);
				AISendEvent('LoudNoise', EAITYPE_Audio, , 512);
			}

			// if we have been blown up, then destroy our contents
			// CNN - don't destroy contents now
//			if (DamageType == 'Exploded')
//			{
//				Contents = None;
//				Content2 = None;
//				Content3 = None;
//			}

			if (bExplosive)
			{
				Frag(fragType, Momentum * explosionRadius / 4, avg/35.0, avg/10 + 1);
				Explode(HitLocation);
			}
			else
				Frag(fragType, Momentum / 10, avg/20.0, avg/5 + 1);
		}
          	if (Damage >= 1)
		{
                        if (DamageSpots[DamageSpotCount] != None)
                         DamageSpots[DamageSpotCount].DelayedDestroy();

		    	DamageSpots[DamageSpotCount] = Spawn(class'ParticleGenerator', Self,, HitLocation);
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Sabot'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.123;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = Damage / 50;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType != 'Sabot') && (DamageType != 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.09;
				DamageSpots[DamageSpotCount].checkTime = 0.035;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
                	if ((Damage >= 25) || (HitPoints < Default.HitPoints / 2))
			{
				Frag(fragType, Momentum / 10, avg/30.0, avg/5 + 1);
			}
		}
	}
}


state Exploding
{
	ignores Explode;

	function Timer()
	{
		local Pawn apawn;
		local float damageRadius;
		local Vector dist;

		if ( Level.NetMode != NM_Standalone )
		{
			damageRadius = (explosionRadius / gradualHurtSteps) * gradualHurtCounter;

			for ( apawn = Level.PawnList; apawn != None; apawn = apawn.nextPawn )
			{
				if ( apawn.IsA('DeusExPlayer') )
				{
					dist = apawn.Location - Location;
					if ( VSize(dist) < damageRadius )
						DeusExPlayer(apawn).myProjKiller = Self;
				}
			}
		}
		HurtRadius
		(
			(2 * explosionDamage) / gradualHurtSteps,
			(explosionRadius / gradualHurtSteps) * gradualHurtCounter,
			'Exploded',
			(explosionDamage / gradualHurtSteps) * 100,
			Location
		);
		if (++gradualHurtCounter >= gradualHurtSteps)
                {
//			Destroy();
       		GoToState('Respawning');
                }
	}

Begin:
	// stagger the HurtRadius outward using Timer()
	// do five separate blast rings increasing in size
	gradualHurtCounter = 1;
	gradualHurtSteps = 5;
	bHidden = True;
        StopMSDriving();
	SetCollision(False, False, False);
        SetCollisionSize(0, Default.CollisionHeight);
       if (RightGun != None)
	 RightGun.bHidden = True;
       if (LeftGun != None)
	 LeftGun.bHidden = True;
        DamageSpots[0].DelayedDestroy();
        DamageSpots[1].DelayedDestroy();
        DamageSpots[2].DelayedDestroy();
        DamageSpots[3].DelayedDestroy();
        DamageSpots[4].DelayedDestroy();
        DamageSpots[5].DelayedDestroy();
        DamageSpots[6].DelayedDestroy();
        DamageSpots[7].DelayedDestroy();
        DamageSpots[8].DelayedDestroy();
        DamageSpots[9].DelayedDestroy();
	SetTimer(0.5/float(gradualHurtSteps), True);
}

state Respawning
{
Begin:
                ResetVehicle();
                Sleep(VehicleRespawnTime);
                bHidden = False;
		SetCollision(True, True, True);
        	SetCollisionSize(Default.CollisionRadius, Default.CollisionHeight);
    	       if (RightGun != None)
		 RightGun.bHidden = False;
       	       if (LeftGun != None)
		 LeftGun.bHidden = False;
                HitPoints = Default.HitPoints;
                ResetScaleGlow();
                GoToState('Active');
}


simulated function CheckForRoadKill(Actor Other)
{
  local name lolnothing;

  ForEach VisibleActors(class'Actor',Other,CollisionRadius * 2 + 10,Location)
  {
    if ((Other != None) && (Other != Self) && (Other != MSCarDriver) && ((Other.IsA('Pawn')) || (Other.IsA('Decoration')) || (Other.IsA('DeusExMover'))) && (Other != MSCarPassenger) && (MSCarSpeed > 0))
    {
      Other.TakeDamage(MSCarSpeed * 360000 /16 /5280, MSCarDriver, Other.Location, Normal(Velocity) * 2000, 'Exploded');
     if (MSCarSpeed * 360000 /16 /5280 > 20)
     {
      if (Other.IsA('DeusExDecoration'))
	DeusExDecoration(Other).bInvincible = False;
      if (Other.IsA('ScriptedPawn'))
	ScriptedPawn(Other).bInvincible = False;
      if (Other.IsA('DeusExPlayer'))
	DeusExPlayer(Other).ReducedDamageType = lolnothing;
      TakeDamage(MSCarSpeed * 360000 /16 /5280 * Other.Mass / 30 / 75 / 5, MSCarDriver, Location, Normal(Velocity) * 2000, 'Exploded'); 
     }
    }
  }
}

simulated function FireDemGuns() //modify this in the subclass if you want more or less projectiles per shot.
{
  local DeusExProjectile proj1, proj2;
  local int i;

   if (ShotTimer <= 0)
   {
    proj1 = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetL >> (Rotation + LeftGunRot)) , Rotation + LeftGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    proj2 = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetR >> (Rotation + RightGunRot)) , Rotation + RightGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    PlaySimSound( MPFiringSound, SLOT_None, TransientSoundVolume, 2048 );
    ShotTimer = ShotTime;
   }
}

simulated function int PlaySimSound( Sound snd, ESoundSlot Slot, float Volume, float Radius )
{
	if ( Owner != None )
	{
		if ( Level.NetMode == NM_Standalone )
			return ( Owner.PlaySound( snd, Slot, Volume, , Radius ) );
		else
		{
			Owner.PlayOwnedSound( snd, Slot, Volume, , Radius );
			return 1;
		}
	}
	return 0;
}

defaultproperties
{
     MSCarDriver=None
     bCanBeBase=True
     bBlockActors=True
     CarSpeed=1
     BrakeStrength=1
     MSAccelerationSpeed=1
     TopGas=1
     bBlockSight=False
     DrivingScreenType=Class'MSDriving1_2.MenuUIDrivingWindow'
     MPDrivingScreenType=Class'MSDriving1_2.MPMenuUIDrivingWindow'
     bUseGas=True
     bInvincible=False
     KnownGuns(0)=Class'MSDriving1_2.DrivableWeaponAssaultGun'
     KnownGuns(1)=Class'MSDriving1_2.DrivableWeaponAssaultShotgun'
     KnownGuns(2)=Class'MSDriving1_2.DrivableWeaponRPG'
     KnownGuns(3)=Class'MSDriving1_2.DrivableWeaponRepeater'
     explosionRadius=420
     explosionDamage=150
     bExplosive=True
     VehicleRespawnTime=15.000000
     ShotTime=1.000000
}
